/*
 * Decompiled with CFR 0.152.
 */
package com.flutter.gradle;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/flutter/gradle/VersionUtils;", "", "()V", "comparePreReleaseIdentifiers", "", "v1Part", "", "v2Part", "mostRecentSemanticVersion", "version1", "version2", "gradle"})
public final class VersionUtils {
    @NotNull
    public static final VersionUtils INSTANCE = new VersionUtils();

    private VersionUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String mostRecentSemanticVersion(@NotNull String version1, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version1, (String)"version1");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version2");
        String[] stringArray = new String[]{".", "-"};
        List v1Parts = StringsKt.split$default((CharSequence)version1, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String[] stringArray2 = new String[]{".", "-"};
        List v2Parts = StringsKt.split$default((CharSequence)version2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        int maxSize = Math.max(v1Parts.size(), v2Parts.size());
        for (int i = 0; i < maxSize; ++i) {
            String string;
            String v1Part;
            String string2 = (String)CollectionsKt.getOrNull((List)v1Parts, (int)i);
            if (string2 == null) {
                string2 = v1Part = "0";
            }
            if ((string = (String)CollectionsKt.getOrNull((List)v2Parts, (int)i)) == null) {
                string = "0";
            }
            String v2Part = string;
            Integer v1Num = StringsKt.toIntOrNull((String)v1Part);
            Integer v2Num = StringsKt.toIntOrNull((String)v2Part);
            if (v1Num != null && v2Num != null) {
                if (Intrinsics.areEqual((Object)v1Num, (Object)v2Num)) continue;
                return v1Num > v2Num ? version1 : version2;
            }
            if (v1Num != null && v2Num == null) {
                return version1;
            }
            if (v1Num == null && v2Num != null) {
                return version2;
            }
            if (Intrinsics.areEqual((Object)v1Part, (Object)v2Part)) continue;
            return INSTANCE.comparePreReleaseIdentifiers(v1Part, v2Part) ? version1 : version2;
        }
        return version1.length() >= version2.length() ? version1 : version2;
    }

    private final boolean comparePreReleaseIdentifiers(String v1Part, String v2Part) {
        String string;
        String v2PreRelease;
        Regex digits = new Regex("\\d");
        CharSequence charSequence = v1Part;
        CharSequence charSequence2 = "";
        String v1PreRelease = digits.replace(charSequence, charSequence2);
        return v1PreRelease.compareTo(v2PreRelease = digits.replace(charSequence2 = (CharSequence)v2Part, string = "")) < 0;
    }
}

