/*
 * Decompiled with CFR 0.152.
 */
package com.flutter.gradle;

import com.android.build.gradle.AbstractAppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.builder.model.BuildType;
import com.flutter.gradle.AppLinkSettings;
import com.flutter.gradle.Deeplink;
import com.flutter.gradle.FlutterExtension;
import com.flutter.gradle.FlutterPluginConstants;
import com.flutter.gradle.FlutterPluginUtils;
import com.flutter.gradle.IntentFilterCheck;
import com.flutter.gradle.PluginVersionPair;
import com.flutter.gradle.VersionFetcher;
import com.flutter.gradle.VersionUtils;
import com.flutter.gradle.plugins.PluginHandler;
import groovy.lang.Closure;
import groovy.util.Node;
import groovy.xml.XmlParser;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.file.Directory;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0001H\u0001J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00012\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0016H\u0001J(\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0001J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0001J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0001J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0001J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0001J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0001J\u0015\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b$J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0001J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J.\u0010/\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u001c\u00100\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010201H\u0001J\u0010\u00103\u001a\u0002042\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u00105\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u0004H\u0001J\u0010\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u0004H\u0007J\u0012\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0015\u0010<\u001a\u00020=2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b>J\u0018\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020@2\u0006\u0010B\u001a\u00020CH\u0001J\u0010\u0010D\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0001J\u0012\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010G\u001a\u00020@2\u0006\u0010\u0011\u001a\u00020\u0012H\u0001J\u0010\u0010H\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0001J\u0018\u0010I\u001a\u00020@2\u0006\u0010A\u001a\u00020@2\u0006\u0010B\u001a\u00020CH\u0001J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020\u0004012\u0006\u0010\u0011\u001a\u00020\u0012H\u0001J\u0010\u0010K\u001a\u00020L2\u0006\u0010\u0011\u001a\u00020\u0012H\u0001J\u0010\u0010M\u001a\u00020L2\u0006\u0010\u0011\u001a\u00020\u0012H\u0001J\u0010\u0010N\u001a\u00020L2\u0006\u0010\u0011\u001a\u00020\u0012H\u0001J\u0010\u0010O\u001a\u00020L2\u0006\u0010\u0011\u001a\u00020\u0012H\u0001J6\u0010P\u001a\u00020\u00102\u0006\u0010Q\u001a\u00020&2\u0006\u0010R\u001a\u00020&2\u0006\u0010B\u001a\u00020C2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020T012\u0006\u0010A\u001a\u00020@H\u0002J6\u0010U\u001a\u00020\u00102\u0006\u0010V\u001a\u00020\u00042\u0006\u0010W\u001a\u00020\u00042\u0006\u0010B\u001a\u00020C2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020T012\u0006\u0010A\u001a\u00020@H\u0002J\u0015\u0010Y\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bZJ\u0010\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020@H\u0001J\u0018\u0010^\u001a\u00020L2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010_\u001a\u00020`H\u0001J\u0010\u0010a\u001a\u00020L2\u0006\u0010\u0011\u001a\u00020\u0012H\u0001J\u0010\u0010b\u001a\u00020L2\u0006\u0010\u0011\u001a\u00020\u0012H\u0001J\u0010\u0010c\u001a\u00020L2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010d\u001a\u00020L2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010e\u001a\u00020\u0004H\u0001J\u0016\u0010f\u001a\u00020\u00042\f\u0010g\u001a\b\u0012\u0004\u0012\u00020\u000401H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006h"}, d2={"Lcom/flutter/gradle/FlutterPluginUtils;", "", "()V", "MANIFEST_NAME_KEY", "", "MANIFEST_VALUE_KEY", "MANIFEST_VALUE_TRUE", "PROP_IS_FAST_START", "PROP_IS_VERBOSE", "PROP_LOCAL_ENGINE_BUILD_MODE", "PROP_LOCAL_ENGINE_REPO", "PROP_SHOULD_SHRINK_RESOURCES", "PROP_SPLIT_PER_ABI", "PROP_TARGET", "PROP_TARGET_PLATFORM", "addApiDependencies", "", "project", "Lorg/gradle/api/Project;", "variantName", "dependency", "config", "Lgroovy/lang/Closure;", "addFlutterDependencies", "buildType", "Lcom/android/builder/model/BuildType;", "pluginHandler", "Lcom/flutter/gradle/plugins/PluginHandler;", "engineVersion", "addTaskForJavaVersion", "addTaskForKGPVersion", "addTaskForPrintBuildVariants", "addTasksForOutputsAppLinkSettings", "buildModeFor", "capitalize", "string", "capitalize$gradle", "compareVersionStrings", "", "firstString", "secondString", "createAppLinkSettings", "Lcom/flutter/gradle/AppLinkSettings;", "variant", "Lcom/android/build/gradle/api/ApplicationVariant;", "baseVariantOutput", "Lcom/android/build/gradle/api/BaseVariantOutput;", "detectLowCompileSdkVersionOrNdkVersion", "pluginList", "", "", "findProcessResources", "Lcom/android/build/gradle/tasks/ProcessAndroidResources;", "forceNdkDownload", "gradleProject", "flutterSdkRootPath", "formatPlatformString", "platform", "getAndroidAppExtensionOrNull", "Lcom/android/build/gradle/AbstractAppExtension;", "getAndroidExtension", "Lcom/android/build/gradle/BaseExtension;", "getAndroidExtension$gradle", "getBuildGradleFileFromProjectDir", "Ljava/io/File;", "projectDirectory", "logger", "Lorg/gradle/api/logging/Logger;", "getCompileSdkFromProject", "getFlutterExtensionOrNull", "Lcom/flutter/gradle/FlutterExtension;", "getFlutterSourceDirectory", "getFlutterTarget", "getSettingsGradleFileFromProjectDir", "getTargetPlatforms", "isBuiltAsApp", "", "isFlutterAppProject", "isProjectFastStart", "isProjectVerbose", "logPluginCompileSdkWarnings", "maxPluginCompileSdkVersion", "projectCompileSdkVersion", "pluginsWithHigherSdkVersion", "Lcom/flutter/gradle/PluginVersionPair;", "logPluginNdkWarnings", "maxPluginNdkVersion", "projectNdkVersion", "pluginsWithDifferentNdkVersion", "lowercase", "lowercase$gradle", "readPropertiesIfExist", "Ljava/util/Properties;", "propertiesFile", "shouldConfigureFlutterTask", "assembleTask", "Lorg/gradle/api/Task;", "shouldProjectSplitPerAbi", "shouldProjectUseLocalEngine", "shouldShrinkResources", "supportsBuildMode", "flutterBuildMode", "toCamelCase", "parts", "gradle"})
@SourceDebugExtension(value={"SMAP\nFlutterPluginUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlutterPluginUtils.kt\ncom/flutter/gradle/FlutterPluginUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,986:1\n1#2:987\n1549#3:988\n1620#3,3:989\n1855#3,2:992\n1855#3,2:994\n800#3,11:996\n766#3:1007\n857#3,2:1008\n1855#3:1010\n800#3,11:1011\n766#3:1022\n857#3,2:1023\n1855#3,2:1025\n800#3,11:1027\n766#3:1038\n857#3,2:1039\n1855#3:1041\n800#3,11:1042\n766#3:1053\n857#3,2:1054\n1855#3,2:1056\n800#3,11:1058\n766#3:1069\n857#3,2:1070\n1855#3,2:1072\n800#3,11:1074\n766#3:1085\n857#3,2:1086\n1855#3:1088\n1856#3:1091\n1855#3:1092\n1855#3:1093\n1855#3,2:1094\n1856#3:1096\n1856#3:1097\n1856#3:1098\n1856#3:1099\n215#4,2:1089\n*S KotlinDebug\n*F\n+ 1 FlutterPluginUtils.kt\ncom/flutter/gradle/FlutterPluginUtils\n*L\n427#1:988\n427#1:989,3\n637#1:992,2\n697#1:994,2\n869#1:996,11\n869#1:1007\n869#1:1008,2\n873#1:1010\n875#1:1011,11\n875#1:1022\n875#1:1023,2\n878#1:1025,2\n888#1:1027,11\n888#1:1038\n888#1:1039,2\n891#1:1041\n902#1:1042,11\n902#1:1053\n902#1:1054,2\n908#1:1056,2\n914#1:1058,11\n914#1:1069\n914#1:1070,2\n917#1:1072,2\n929#1:1074,11\n929#1:1085\n929#1:1086,2\n932#1:1088\n932#1:1091\n961#1:1092\n962#1:1093\n963#1:1094,2\n962#1:1096\n961#1:1097\n891#1:1098\n873#1:1099\n933#1:1089,2\n*E\n"})
public final class FlutterPluginUtils {
    @NotNull
    public static final FlutterPluginUtils INSTANCE = new FlutterPluginUtils();
    @NotNull
    private static final String MANIFEST_NAME_KEY = "android:name";
    @NotNull
    private static final String MANIFEST_VALUE_KEY = "android:value";
    @NotNull
    private static final String MANIFEST_VALUE_TRUE = "true";
    @NotNull
    public static final String PROP_SHOULD_SHRINK_RESOURCES = "shrink";
    @NotNull
    public static final String PROP_SPLIT_PER_ABI = "split-per-abi";
    @NotNull
    public static final String PROP_LOCAL_ENGINE_REPO = "local-engine-repo";
    @NotNull
    public static final String PROP_IS_VERBOSE = "verbose";
    @NotNull
    public static final String PROP_IS_FAST_START = "fast-start";
    @NotNull
    public static final String PROP_TARGET = "target";
    @NotNull
    public static final String PROP_LOCAL_ENGINE_BUILD_MODE = "local-engine-build-mode";
    @NotNull
    public static final String PROP_TARGET_PLATFORM = "target-platform";

    private FlutterPluginUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String toCamelCase(@NotNull List<String> parts) {
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        if (parts.isEmpty()) {
            return "";
        }
        return parts.get(0) + CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)parts, (int)1), (CharSequence)"", null, null, (int)0, null, (Function1)toCamelCase.1.INSTANCE, (int)30, null);
    }

    @JvmStatic
    @NotNull
    public static final String capitalize$gradle(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return StringsKt.capitalize((String)string);
    }

    @NotNull
    public final String lowercase$gradle(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    @JvmStatic
    @JvmName(name="compareVersionStrings")
    public static final int compareVersionStrings(@NotNull String firstString, @NotNull String secondString) {
        Intrinsics.checkNotNullParameter((Object)firstString, (String)"firstString");
        Intrinsics.checkNotNullParameter((Object)secondString, (String)"secondString");
        String[] stringArray = new String[]{"."};
        List firstVersion = StringsKt.split$default((CharSequence)firstString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String[] stringArray2 = new String[]{"."};
        List secondVersion = StringsKt.split$default((CharSequence)secondString, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        int commonIndices = Math.min(firstVersion.size(), secondVersion.size());
        for (int i = 0; i < commonIndices; ++i) {
            String firstAtIndex = (String)firstVersion.get(i);
            String secondAtIndex = (String)secondVersion.get(i);
            int firstInt = 0;
            int secondInt = 0;
            firstAtIndex = StringsKt.substringBefore$default((String)firstAtIndex, (String)"-", null, (int)2, null);
            try {
                firstInt = Integer.parseInt(firstAtIndex);
            }
            catch (NumberFormatException nfe) {
                System.out.println(nfe);
            }
            secondAtIndex = StringsKt.substringBefore$default((String)secondAtIndex, (String)"-", null, (int)2, null);
            try {
                secondInt = Integer.parseInt(secondAtIndex);
            }
            catch (NumberFormatException nfe) {
                System.out.println(nfe);
            }
            int comparisonResult = Intrinsics.compare((int)firstInt, (int)secondInt);
            if (comparisonResult == 0) continue;
            return comparisonResult;
        }
        return Intrinsics.compare((int)firstVersion.size(), (int)secondVersion.size());
    }

    @JvmStatic
    @JvmName(name="formatPlatformString")
    @NotNull
    public static final String formatPlatformString(@NotNull String platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        String string = FlutterPluginConstants.getPLATFORM_ARCH_MAP().get(platform);
        Intrinsics.checkNotNull((Object)string);
        return StringsKt.replace$default((String)string, (String)"-", (String)"_", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmName(name="readPropertiesIfExist")
    @NotNull
    public static final Properties readPropertiesIfExist(@NotNull File propertiesFile) {
        Intrinsics.checkNotNullParameter((Object)propertiesFile, (String)"propertiesFile");
        Properties result = new Properties();
        if (propertiesFile.exists()) {
            Object object = propertiesFile;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Object object2 = charset;
            object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
            object2 = null;
            try {
                InputStreamReader reader = (InputStreamReader)object;
                boolean bl = false;
                result.load(reader);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        return result;
    }

    @JvmStatic
    @JvmName(name="shouldShrinkResources")
    public static final boolean shouldShrinkResources(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (project.hasProperty(PROP_SHOULD_SHRINK_RESOURCES)) {
            Object propertyValue = project.property(PROP_SHOULD_SHRINK_RESOURCES);
            return Boolean.parseBoolean(String.valueOf(propertyValue));
        }
        return true;
    }

    @JvmStatic
    @JvmName(name="getSettingsGradleFileFromProjectDir")
    @NotNull
    public static final File getSettingsGradleFileFromProjectDir(@NotNull File projectDirectory, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        File settingsGradle = new File(projectDirectory.getParentFile(), "settings.gradle");
        File settingsGradleKts = new File(projectDirectory.getParentFile(), "settings.gradle.kts");
        if (settingsGradle.exists() && settingsGradleKts.exists()) {
            logger.error("Both settings.gradle and settings.gradle.kts exist, so\nsettings.gradle.kts is ignored. This is likely a mistake.");
        }
        return settingsGradle.exists() ? settingsGradle : settingsGradleKts;
    }

    @JvmStatic
    @JvmName(name="getBuildGradleFileFromProjectDir")
    @NotNull
    public static final File getBuildGradleFileFromProjectDir(@NotNull File projectDirectory, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        File buildGradle = new File(new File(projectDirectory.getParentFile(), "app"), "build.gradle");
        File buildGradleKts = new File(new File(projectDirectory.getParentFile(), "app"), "build.gradle.kts");
        if (buildGradle.exists() && buildGradleKts.exists()) {
            logger.error("Both build.gradle and build.gradle.kts exist, so\nbuild.gradle.kts is ignored. This is likely a mistake.");
        }
        return buildGradle.exists() ? buildGradle : buildGradleKts;
    }

    @JvmStatic
    @JvmName(name="shouldProjectSplitPerAbi")
    public static final boolean shouldProjectSplitPerAbi(@NotNull Project project) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = project.findProperty(PROP_SPLIT_PER_ABI);
        return object != null && (string = object.toString()) != null ? Boolean.parseBoolean(string) : false;
    }

    @JvmStatic
    @JvmName(name="shouldProjectUseLocalEngine")
    public static final boolean shouldProjectUseLocalEngine(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return project.hasProperty(PROP_LOCAL_ENGINE_REPO);
    }

    @JvmStatic
    @JvmName(name="isProjectVerbose")
    public static final boolean isProjectVerbose(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = project.findProperty(PROP_IS_VERBOSE);
        return object != null && (object = object.toString()) != null ? Boolean.parseBoolean((String)object) : false;
    }

    @JvmStatic
    @JvmName(name="isProjectFastStart")
    public static final boolean isProjectFastStart(@NotNull Project project) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = project.findProperty(PROP_IS_FAST_START);
        return object != null && (string = object.toString()) != null ? Boolean.parseBoolean(string) : false;
    }

    @JvmStatic
    @JvmName(name="shouldConfigureFlutterTask")
    public static final boolean shouldConfigureFlutterTask(@NotNull Project project, @NotNull Task assembleTask) {
        List cliTasksNames;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)assembleTask, (String)"assembleTask");
                List list = project.getGradle().getStartParameter().getTaskNames();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"project.gradle.startParameter.taskNames");
                cliTasksNames = list;
                if (cliTasksNames.size() != 1) break block11;
                Object object = CollectionsKt.first((List)cliTasksNames);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cliTasksNames.first()");
                if (StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"assemble", (boolean)false, (int)2, null)) break block12;
            }
            return true;
        }
        Object object = CollectionsKt.first((List)cliTasksNames);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cliTasksNames.first()");
        String[] stringArray = new String[]{":"};
        String taskName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)object), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (Intrinsics.areEqual((Object)taskName, (Object)"assemble")) {
            return true;
        }
        if (Intrinsics.areEqual((Object)taskName, (Object)assembleTask.getName())) {
            return true;
        }
        if (StringsKt.endsWith$default((String)taskName, (String)"Release", (boolean)false, (int)2, null)) {
            String string = assembleTask.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"assembleTask.name");
            if (StringsKt.endsWith$default((String)string, (String)"Release", (boolean)false, (int)2, null)) {
                return true;
            }
        }
        if (StringsKt.endsWith$default((String)taskName, (String)"Debug", (boolean)false, (int)2, null)) {
            String string = assembleTask.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"assembleTask.name");
            if (StringsKt.endsWith$default((String)string, (String)"Debug", (boolean)false, (int)2, null)) {
                return true;
            }
        }
        if (StringsKt.endsWith$default((String)taskName, (String)"Profile", (boolean)false, (int)2, null)) {
            String string = assembleTask.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"assembleTask.name");
            if (StringsKt.endsWith$default((String)string, (String)"Profile", (boolean)false, (int)2, null)) {
                return true;
            }
        }
        return false;
    }

    private final FlutterExtension getFlutterExtensionOrNull(Project project) {
        return (FlutterExtension)project.getExtensions().findByType(FlutterExtension.class);
    }

    @JvmStatic
    @JvmName(name="getFlutterSourceDirectory")
    @NotNull
    public static final File getFlutterSourceDirectory(@NotNull Project project) {
        FlutterExtension flutterExtension;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FlutterExtension flutterExtension2 = flutterExtension = INSTANCE.getFlutterExtensionOrNull(project);
        Intrinsics.checkNotNull((Object)flutterExtension2);
        if (flutterExtension2.getSource() == null) {
            throw new GradleException("Flutter source directory not set.");
        }
        String string = flutterExtension.getSource();
        Intrinsics.checkNotNull((Object)string);
        File file = project.file((Object)string);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(flutterExtension.source!!)");
        return file;
    }

    @JvmStatic
    @JvmName(name="getFlutterTarget")
    @NotNull
    public static final String getFlutterTarget(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (project.hasProperty(PROP_TARGET)) {
            return String.valueOf(project.property(PROP_TARGET));
        }
        FlutterExtension flutterExtension = INSTANCE.getFlutterExtensionOrNull(project);
        Intrinsics.checkNotNull((Object)flutterExtension);
        String string = flutterExtension.getTarget();
        if (string == null) {
            string = "lib/main.dart";
        }
        String target = string;
        return target;
    }

    @JvmStatic
    @JvmName(name="isBuiltAsApp")
    public static final boolean isBuiltAsApp(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return project.getPlugins().hasPlugin("com.android.application");
    }

    @JvmStatic
    @JvmName(name="addApiDependencies")
    public static final void addApiDependencies(@NotNull Project project, @NotNull String variantName, @NotNull Object dependency) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        FlutterPluginUtils.addApiDependencies(project, variantName, dependency, null);
    }

    @JvmStatic
    @JvmName(name="addApiDependencies")
    public static final void addApiDependencies(@NotNull Project project, @NotNull String variantName, @NotNull Object dependency, @Nullable Closure<Object> config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        String configuration = null;
        try {
            project.getConfigurations().named("api");
            configuration = variantName + "Api";
        }
        catch (UnknownTaskException ignored) {
            configuration = variantName + "Compile";
        }
        if (config == null) {
            project.getDependencies().add(configuration, dependency);
        } else {
            project.getDependencies().add(configuration, dependency, config);
        }
    }

    @JvmStatic
    @JvmName(name="buildModeFor")
    @NotNull
    public static final String buildModeFor(@NotNull BuildType buildType) {
        Intrinsics.checkNotNullParameter((Object)buildType, (String)"buildType");
        if (Intrinsics.areEqual((Object)buildType.getName(), (Object)"profile")) {
            return "profile";
        }
        if (buildType.isDebuggable()) {
            return "debug";
        }
        return "release";
    }

    @JvmStatic
    @JvmName(name="supportsBuildMode")
    public static final boolean supportsBuildMode(@NotNull Project project, @NotNull String flutterBuildMode) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)flutterBuildMode, (String)"flutterBuildMode");
        if (!FlutterPluginUtils.shouldProjectUseLocalEngine(project)) {
            return true;
        }
        if (!project.hasProperty(PROP_LOCAL_ENGINE_BUILD_MODE)) {
            boolean bl = false;
            String string = "Project must have property 'local-engine-build-mode'";
            throw new IllegalStateException(string.toString());
        }
        return Intrinsics.areEqual((Object)project.property(PROP_LOCAL_ENGINE_BUILD_MODE), (Object)flutterBuildMode);
    }

    @NotNull
    public final BaseExtension getAndroidExtension$gradle(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = project.getExtensions().findByType(BaseExtension.class);
        Intrinsics.checkNotNull((Object)object);
        return (BaseExtension)object;
    }

    private final AbstractAppExtension getAndroidAppExtensionOrNull(Project project) {
        return (AbstractAppExtension)project.getExtensions().findByType(AbstractAppExtension.class);
    }

    @JvmStatic
    @JvmName(name="getCompileSdkFromProject")
    @NotNull
    public static final String getCompileSdkFromProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = INSTANCE.getAndroidExtension$gradle(project).getCompileSdkVersion();
        Intrinsics.checkNotNull((Object)string);
        String string2 = string.substring(8);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmName(name="getTargetPlatforms")
    @NotNull
    public static final List<String> getTargetPlatforms(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!project.hasProperty(PROP_TARGET_PLATFORM)) {
            return FlutterPluginConstants.getDEFAULT_PLATFORMS();
        }
        Object object = project.property(PROP_TARGET_PLATFORM);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String platformsString = (String)object;
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)platformsString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void platform;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!FlutterPluginConstants.getPLATFORM_ARCH_MAP().containsKey(platform)) {
                throw new GradleException("Invalid platform: " + (String)platform);
            }
            collection.add(platform);
        }
        return (List)destination$iv$iv;
    }

    private final void logPluginCompileSdkWarnings(int maxPluginCompileSdkVersion, int projectCompileSdkVersion, Logger logger, List<PluginVersionPair> pluginsWithHigherSdkVersion, File projectDirectory) {
        logger.error("Your project is configured to compile against Android SDK " + projectCompileSdkVersion + ", but the following plugin(s) require to be compiled against a higher Android SDK version:");
        for (PluginVersionPair pluginToCompileSdkVersion : pluginsWithHigherSdkVersion) {
            logger.error("- " + pluginToCompileSdkVersion.getName() + " compiles against Android SDK " + pluginToCompileSdkVersion.getVersion());
        }
        File buildGradleFile = FlutterPluginUtils.getBuildGradleFileFromProjectDir(projectDirectory, logger);
        logger.error(StringsKt.trimIndent((String)("\n            Fix this issue by compiling against the highest Android SDK version (they are backward compatible).\n            Add the following to " + buildGradleFile.getPath() + ":\n\n                android {\n                    compileSdk = " + maxPluginCompileSdkVersion + "\n                    ...\n                }\n            ")));
    }

    private final void logPluginNdkWarnings(String maxPluginNdkVersion, String projectNdkVersion, Logger logger, List<PluginVersionPair> pluginsWithDifferentNdkVersion, File projectDirectory) {
        logger.error("Your project is configured with Android NDK " + projectNdkVersion + ", but the following plugin(s) depend on a different Android NDK version:");
        for (PluginVersionPair pluginToNdkVersion : pluginsWithDifferentNdkVersion) {
            logger.error("- " + pluginToNdkVersion.getName() + " requires Android NDK " + pluginToNdkVersion.getVersion());
        }
        File buildGradleFile = FlutterPluginUtils.getBuildGradleFileFromProjectDir(projectDirectory, logger);
        logger.error(StringsKt.trimIndent((String)("\n            Fix this issue by using the highest Android NDK version (they are backward compatible).\n            Add the following to " + buildGradleFile.getPath() + ":\n\n                android {\n                    ndkVersion = \"" + maxPluginNdkVersion + "\"\n                    ...\n                }\n            ")));
    }

    @JvmStatic
    @JvmName(name="detectLowCompileSdkVersionOrNdkVersion")
    public static final void detectLowCompileSdkVersionOrNdkVersion(@NotNull Project project, @NotNull List<? extends Map<String, ? extends Object>> pluginList) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(pluginList, (String)"pluginList");
        project.afterEvaluate(new Action(project, pluginList){
            final /* synthetic */ Project $project;
            final /* synthetic */ List<Map<String, Object>> $pluginList;
            {
                this.$project = $project;
                this.$pluginList = $pluginList;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(@NotNull Project $this$afterEvaluate) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                Integer n = StringsKt.toIntOrNull((String)FlutterPluginUtils.getCompileSdkFromProject(this.$project));
                int projectCompileSdkVersion = n != null ? n : Integer.MAX_VALUE;
                Ref.IntRef maxPluginCompileSdkVersion = new Ref.IntRef();
                maxPluginCompileSdkVersion.element = projectCompileSdkVersion;
                String ndkVersionIfUnspecified = "21.1.6352462";
                String string = FlutterPluginUtils.INSTANCE.getAndroidExtension$gradle(this.$project).getNdkVersion();
                if (string == null) {
                    string = ndkVersionIfUnspecified;
                }
                String projectNdkVersion = string;
                Ref.ObjectRef maxPluginNdkVersion = new Ref.ObjectRef();
                maxPluginNdkVersion.element = projectNdkVersion;
                Ref.IntRef numProcessedPlugins = new Ref.IntRef();
                numProcessedPlugins.element = this.$pluginList.size();
                List pluginsWithHigherSdkVersion = new ArrayList<E>();
                List pluginsWithDifferentNdkVersion = new ArrayList<E>();
                Iterable iterable = this.$pluginList;
                Project project = this.$project;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Project project2;
                    String pluginName;
                    Map pluginObject = (Map)element$iv;
                    boolean bl = false;
                    V v = pluginObject.get("name");
                    if ((v instanceof String ? (String)v : null) == null) {
                        boolean bl2 = false;
                        String string2 = "Missing valid \"name\" property for plugin object: " + pluginObject;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    pluginName = pluginName;
                    Project project3 = project2 = project.getRootProject().findProject(":" + pluginName);
                    if (project3 == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project.rootProject.find\u2026nName\") ?: return@forEach");
                    Project pluginProject = project2;
                    pluginProject.afterEvaluate(new Action(pluginProject, maxPluginCompileSdkVersion, projectCompileSdkVersion, pluginsWithHigherSdkVersion, pluginName, ndkVersionIfUnspecified, (Ref.ObjectRef<String>)maxPluginNdkVersion, projectNdkVersion, pluginsWithDifferentNdkVersion, numProcessedPlugins, project){
                        final /* synthetic */ Project $pluginProject;
                        final /* synthetic */ Ref.IntRef $maxPluginCompileSdkVersion;
                        final /* synthetic */ int $projectCompileSdkVersion;
                        final /* synthetic */ List<PluginVersionPair> $pluginsWithHigherSdkVersion;
                        final /* synthetic */ String $pluginName;
                        final /* synthetic */ String $ndkVersionIfUnspecified;
                        final /* synthetic */ Ref.ObjectRef<String> $maxPluginNdkVersion;
                        final /* synthetic */ String $projectNdkVersion;
                        final /* synthetic */ List<PluginVersionPair> $pluginsWithDifferentNdkVersion;
                        final /* synthetic */ Ref.IntRef $numProcessedPlugins;
                        final /* synthetic */ Project $project;
                        {
                            this.$pluginProject = $pluginProject;
                            this.$maxPluginCompileSdkVersion = $maxPluginCompileSdkVersion;
                            this.$projectCompileSdkVersion = $projectCompileSdkVersion;
                            this.$pluginsWithHigherSdkVersion = $pluginsWithHigherSdkVersion;
                            this.$pluginName = $pluginName;
                            this.$ndkVersionIfUnspecified = $ndkVersionIfUnspecified;
                            this.$maxPluginNdkVersion = $maxPluginNdkVersion;
                            this.$projectNdkVersion = $projectNdkVersion;
                            this.$pluginsWithDifferentNdkVersion = $pluginsWithDifferentNdkVersion;
                            this.$numProcessedPlugins = $numProcessedPlugins;
                            this.$project = $project;
                        }

                        public final void execute(@NotNull Project $this$afterEvaluate) {
                            String string;
                            Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                            Integer n = StringsKt.toIntOrNull((String)FlutterPluginUtils.getCompileSdkFromProject(this.$pluginProject));
                            int pluginCompileSdkVersion = n != null ? n : Integer.MAX_VALUE;
                            this.$maxPluginCompileSdkVersion.element = Math.max(this.$maxPluginCompileSdkVersion.element, pluginCompileSdkVersion);
                            if (pluginCompileSdkVersion > this.$projectCompileSdkVersion) {
                                this.$pluginsWithHigherSdkVersion.add(new PluginVersionPair(this.$pluginName, String.valueOf(pluginCompileSdkVersion)));
                            }
                            if ((string = FlutterPluginUtils.INSTANCE.getAndroidExtension$gradle(this.$pluginProject).getNdkVersion()) == null) {
                                string = this.$ndkVersionIfUnspecified;
                            }
                            String pluginNdkVersion = string;
                            this.$maxPluginNdkVersion.element = VersionUtils.mostRecentSemanticVersion(pluginNdkVersion, (String)this.$maxPluginNdkVersion.element);
                            if (!Intrinsics.areEqual((Object)pluginNdkVersion, (Object)this.$projectNdkVersion)) {
                                this.$pluginsWithDifferentNdkVersion.add(new PluginVersionPair(this.$pluginName, pluginNdkVersion));
                            }
                            int n2 = this.$numProcessedPlugins.element;
                            this.$numProcessedPlugins.element = n2 + -1;
                            if (this.$numProcessedPlugins.element == 0) {
                                if (this.$maxPluginCompileSdkVersion.element > this.$projectCompileSdkVersion) {
                                    int n3 = this.$maxPluginCompileSdkVersion.element;
                                    Logger logger = this.$project.getLogger();
                                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
                                    File file = this.$project.getProjectDir();
                                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
                                    FlutterPluginUtils.access$logPluginCompileSdkWarnings(FlutterPluginUtils.INSTANCE, n3, this.$projectCompileSdkVersion, logger, this.$pluginsWithHigherSdkVersion, file);
                                }
                                if (!Intrinsics.areEqual((Object)this.$maxPluginNdkVersion.element, (Object)this.$projectNdkVersion)) {
                                    String string2 = (String)this.$maxPluginNdkVersion.element;
                                    Logger logger = this.$project.getLogger();
                                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
                                    File file = this.$project.getProjectDir();
                                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
                                    FlutterPluginUtils.access$logPluginNdkWarnings(FlutterPluginUtils.INSTANCE, string2, this.$projectNdkVersion, logger, this.$pluginsWithDifferentNdkVersion, file);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    @JvmStatic
    @JvmName(name="forceNdkDownload")
    public static final void forceNdkDownload(@NotNull Project gradleProject, @NotNull String flutterSdkRootPath) {
        boolean forcingNotRequired;
        Intrinsics.checkNotNullParameter((Object)gradleProject, (String)"gradleProject");
        Intrinsics.checkNotNullParameter((Object)flutterSdkRootPath, (String)"flutterSdkRootPath");
        BaseExtension gradleProjectAndroidExtension = INSTANCE.getAndroidExtension$gradle(gradleProject);
        boolean bl = forcingNotRequired = gradleProjectAndroidExtension.getExternalNativeBuild().getCmake().getPath() != null;
        if (forcingNotRequired) {
            return;
        }
        gradleProjectAndroidExtension.getExternalNativeBuild().getCmake().path((Object)(flutterSdkRootPath + "/packages/flutter_tools/gradle/src/main/scripts/CMakeLists.txt"));
        gradleProjectAndroidExtension.getExternalNativeBuild().getCmake().buildStagingDirectory((Object)((Directory)gradleProject.getLayout().getBuildDirectory().dir("../.cxx").get()).getAsFile().getPath());
        Iterable $this$forEach$iv = (Iterable)gradleProjectAndroidExtension.getBuildTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            com.android.build.gradle.internal.dsl.BuildType buildType = (com.android.build.gradle.internal.dsl.BuildType)element$iv;
            boolean bl2 = false;
            String[] stringArray = new String[]{"-Wno-dev", "--no-warn-unused-cli", "-DCMAKE_BUILD_TYPE=" + buildType.getName()};
            buildType.getExternalNativeBuild().getCmake().arguments(stringArray);
        }
    }

    @JvmStatic
    @JvmName(name="isFlutterAppProject")
    public static final boolean isFlutterAppProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return project.getExtensions().findByType(AbstractAppExtension.class) != null;
    }

    @JvmStatic
    @JvmName(name="addFlutterDependencies")
    public static final void addFlutterDependencies(@NotNull Project project, @NotNull BuildType buildType, @NotNull PluginHandler pluginHandler, @NotNull String engineVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildType, (String)"buildType");
        Intrinsics.checkNotNullParameter((Object)pluginHandler, (String)"pluginHandler");
        Intrinsics.checkNotNullParameter((Object)engineVersion, (String)"engineVersion");
        String flutterBuildMode = FlutterPluginUtils.buildModeFor(buildType);
        if (!FlutterPluginUtils.supportsBuildMode(project, flutterBuildMode)) {
            project.getLogger().quiet("Project does not support Flutter build mode: " + flutterBuildMode + ", skipping adding Flutter dependencies");
            return;
        }
        List<Map<String, Object>> pluginsThatIncludeFlutterEmbeddingAsTransitiveDependency = Intrinsics.areEqual((Object)flutterBuildMode, (Object)"release") ? pluginHandler.getPluginListWithoutDevDependencies$gradle() : pluginHandler.getPluginList$gradle();
        if (!FlutterPluginUtils.isFlutterAppProject(project) || pluginsThatIncludeFlutterEmbeddingAsTransitiveDependency.isEmpty()) {
            FlutterPluginUtils.addApiDependencies(project, buildType.getName(), "io.flutter:flutter_embedding_" + flutterBuildMode + ":" + engineVersion);
        }
        List<String> platforms = FlutterPluginUtils.getTargetPlatforms(project);
        Iterable $this$forEach$iv = platforms;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String platform = (String)element$iv;
            boolean bl = false;
            String arch = FlutterPluginUtils.formatPlatformString(platform);
            FlutterPluginUtils.addApiDependencies(project, buildType.getName(), "io.flutter:" + arch + "_" + flutterBuildMode + ":" + engineVersion);
        }
    }

    @JvmStatic
    @JvmName(name="addTaskForJavaVersion")
    public static final void addTaskForJavaVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getTasks().register("javaVersion", (Action)addTaskForJavaVersion.1.INSTANCE);
    }

    @JvmStatic
    @JvmName(name="addTaskForKGPVersion")
    public static final void addTaskForKGPVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getTasks().register("kgpVersion", new Action(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setDescription("Print the current kgp version used by the project.");
                $this$register.doLast(new Action(this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                    }

                    public final void execute(@NotNull Task $this$doLast) {
                        Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$this$doLast");
                        System.out.println((Object)("KGP Version: " + VersionFetcher.INSTANCE.getKGPVersion$gradle(this.$project)));
                    }
                });
            }
        });
    }

    @JvmStatic
    @JvmName(name="addTaskForPrintBuildVariants")
    public static final void addTaskForPrintBuildVariants(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = project.getExtensions().getByType(AbstractAppExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.getBy\u2026AppExtension::class.java)");
        AbstractAppExtension androidExtension = (AbstractAppExtension)object;
        project.getTasks().register("printBuildVariants", new Action(androidExtension){
            final /* synthetic */ AbstractAppExtension $androidExtension;
            {
                this.$androidExtension = $androidExtension;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setDescription("Prints out all build variants for this Android project");
                $this$register.doLast(new Action(this.$androidExtension){
                    final /* synthetic */ AbstractAppExtension $androidExtension;
                    {
                        this.$androidExtension = $androidExtension;
                    }

                    public final void execute(@NotNull Task $this$doLast) {
                        Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$this$doLast");
                        Iterable $this$forEach$iv = (Iterable)this.$androidExtension.getApplicationVariants();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            ApplicationVariant variant = (ApplicationVariant)element$iv;
                            boolean bl = false;
                            System.out.println((Object)("BuildVariant: " + variant.getName()));
                        }
                    }
                });
            }
        });
    }

    private final ProcessAndroidResources findProcessResources(BaseVariantOutput baseVariantOutput) {
        TaskProvider taskProvider = baseVariantOutput.getProcessResourcesProvider();
        Object object = taskProvider != null ? (ProcessAndroidResources)taskProvider.get() : null;
        if (object == null) {
            ProcessAndroidResources processAndroidResources = baseVariantOutput.getProcessResources();
            object = processAndroidResources;
            Intrinsics.checkNotNullExpressionValue((Object)processAndroidResources, (String)"baseVariantOutput.processResources");
        }
        return object;
    }

    @JvmStatic
    @JvmName(name="addTasksForOutputsAppLinkSettings")
    public static final void addTasksForOutputsAppLinkSettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AbstractAppExtension android = INSTANCE.getAndroidAppExtensionOrNull(project);
        if (android == null) {
            project.getLogger().info("addTasksForOutputsAppLinkSettings called on project without android extension.");
            return;
        }
        android.getApplicationVariants().configureEach(new Action(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final void execute(@NotNull ApplicationVariant $this$configureEach) {
                Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                ApplicationVariant variant = $this$configureEach;
                TaskContainer taskContainer = this.$project.getTasks();
                String string = variant.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
                taskContainer.register("output" + FlutterPluginUtils.capitalize$gradle(string) + "AppLinkSettings", new Action(variant, this.$project){
                    final /* synthetic */ ApplicationVariant $variant;
                    final /* synthetic */ Project $project;
                    {
                        this.$variant = $variant;
                        this.$project = $project;
                    }

                    public final void execute(@NotNull Task $this$register) {
                        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                        Task task = $this$register;
                        task.setDescription("stores app links settings for the given build variant of this Android project into a json file.");
                        this.$variant.getOutputs().configureEach(new Action($this$register){
                            final /* synthetic */ Task $this_register;
                            {
                                this.$this_register = $this_register;
                            }

                            public final void execute(@NotNull BaseVariantOutput $this$configureEach) {
                                Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                                BaseVariantOutput baseVariantOutput = $this$configureEach;
                                Object[] objectArray = new Object[]{FlutterPluginUtils.access$findProcessResources(FlutterPluginUtils.INSTANCE, baseVariantOutput)};
                                this.$this_register.dependsOn(objectArray);
                            }
                        });
                        $this$register.doLast(new Action(this.$variant, this.$project){
                            final /* synthetic */ ApplicationVariant $variant;
                            final /* synthetic */ Project $project;
                            {
                                this.$variant = $variant;
                                this.$project = $project;
                            }

                            public final void execute(@NotNull Task $this$doLast) {
                                Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$this$doLast");
                                this.$variant.getOutputs().configureEach(new Action(this.$variant, this.$project){
                                    final /* synthetic */ ApplicationVariant $variant;
                                    final /* synthetic */ Project $project;
                                    {
                                        this.$variant = $variant;
                                        this.$project = $project;
                                    }

                                    public final void execute(@NotNull BaseVariantOutput $this$configureEach) {
                                        Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                                        AppLinkSettings appLinkSettings = FlutterPluginUtils.access$createAppLinkSettings(FlutterPluginUtils.INSTANCE, this.$variant, $this$configureEach);
                                        FilesKt.writeText$default((File)new File(String.valueOf(this.$project.property("outputPath"))), (String)appLinkSettings.toJson().toString(), null, (int)2, null);
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final AppLinkSettings createAppLinkSettings(ApplicationVariant variant, BaseVariantOutput baseVariantOutput) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Object v2;
        Object object2;
        AppLinkSettings appLinkSettings;
        block35: {
            appLinkSettings = new AppLinkSettings(variant.getApplicationId());
            Node node = new XmlParser(false, false).parse(this.findProcessResources(baseVariantOutput).getManifestFile());
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"XmlParser(false, false)\n\u2026iantOutput).manifestFile)");
            Node manifest = node;
            List list = manifest.children();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"manifest.children()");
            Iterable iterable = list;
            for (Object object2 : iterable) {
                Object node2 = object2;
                boolean bl = false;
                if (!(node2 instanceof Node && Intrinsics.areEqual((Object)((Node)node2).name(), (Object)"application"))) continue;
                v2 = object2;
                break block35;
            }
            v2 = null;
        }
        Node applicationNode = v2;
        if (applicationNode == null) {
            return appLinkSettings;
        }
        List list = applicationNode.children();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"applicationNode.children()");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        object2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Node)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Node item = (Node)element$iv$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)item.name(), (Object)"activity")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List activities = (List)destination$iv$iv;
        Iterable $this$forEach$iv = activities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            void $this$filterIsInstanceTo$iv$iv2;
            Object element$iv2;
            Iterator $this$filterTo$iv$iv3;
            void $this$filter$iv3;
            void $this$filterIsInstanceTo$iv$iv3;
            Node activity = (Node)element$iv;
            boolean bl = false;
            List list2 = activity.children();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"activity.children()");
            Iterable $this$filterIsInstance$iv2 = list2;
            boolean $i$f$filterIsInstance2 = false;
            Iterable bl2 = $this$filterIsInstance$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo2 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
                if (!(element$iv$iv instanceof Node)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
            boolean $i$f$filter2 = false;
            $this$filterIsInstanceTo$iv$iv3 = $this$filter$iv3;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            Iterator iterator = $this$filterTo$iv$iv3.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv;
                element$iv$iv = iterator.next();
                Node metaItem = (Node)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)metaItem.name(), (Object)"meta-data")) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List metaDataItems = (List)destination$iv$iv2;
            Iterable $this$forEach$iv2 = metaDataItems;
            boolean $i$f$forEach2 = false;
            $this$filterTo$iv$iv3 = $this$forEach$iv2.iterator();
            while ($this$filterTo$iv$iv3.hasNext()) {
                element$iv2 = $this$filterTo$iv$iv3.next();
                Node metaDataItem = (Node)element$iv2;
                boolean bl4 = false;
                boolean nameAttribute = Intrinsics.areEqual((Object)metaDataItem.attribute((Object)MANIFEST_NAME_KEY), (Object)"flutter_deeplinking_enabled");
                boolean valueAttribute = Intrinsics.areEqual((Object)metaDataItem.attribute((Object)MANIFEST_VALUE_KEY), (Object)MANIFEST_VALUE_TRUE);
                if (!nameAttribute || !valueAttribute) continue;
                appLinkSettings.setDeeplinkingFlagEnabled(true);
            }
            List list3 = activity.children();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"activity.children()");
            Iterable $this$filterIsInstance$iv3 = list3;
            boolean $i$f$filterIsInstance3 = false;
            element$iv2 = $this$filterIsInstance$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIsInstanceTo3 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof Node)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filterIsInstance$iv3 = (List)destination$iv$iv3;
            boolean $i$f$filter3 = false;
            $this$filterIsInstanceTo$iv$iv2 = $this$filter$iv2;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Node filterItem = (Node)element$iv$iv;
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)filterItem.name(), (Object)"intent-filter")) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List intentFilterItems = (List)destination$iv$iv3;
            Iterable $this$forEach$iv3 = intentFilterItems;
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                void $this$filterTo$iv$iv4;
                void $this$filter$iv4;
                void $this$filterIsInstanceTo$iv$iv4;
                Object element$iv4;
                Iterator $this$filterTo$iv$iv5;
                void $this$filter$iv5;
                Object element$iv$iv3;
                void $this$filterIsInstanceTo$iv$iv5;
                Object element$iv5;
                Iterator $this$filterTo$iv$iv6;
                void $this$filter$iv6;
                Object element$iv$iv22;
                void $this$filterIsInstanceTo$iv$iv6;
                Node appLinkIntent = (Node)element$iv3;
                boolean bl6 = false;
                Set schemes = new LinkedHashSet();
                Set hosts = new LinkedHashSet();
                Set paths = new LinkedHashSet();
                IntentFilterCheck intentFilterCheck = new IntentFilterCheck();
                if (Intrinsics.areEqual((Object)appLinkIntent.attribute((Object)"android:autoVerify"), (Object)MANIFEST_VALUE_TRUE)) {
                    intentFilterCheck.setHasAutoVerify(true);
                }
                List list4 = appLinkIntent.children();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"appLinkIntent.children()");
                Iterable $this$filterIsInstance$iv4 = list4;
                boolean $i$f$filterIsInstance4 = false;
                Iterable iterable = $this$filterIsInstance$iv4;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterIsInstanceTo4 = false;
                for (Object element$iv$iv22 : $this$filterIsInstanceTo$iv$iv6) {
                    if (!(element$iv$iv22 instanceof Node)) continue;
                    destination$iv$iv4.add(element$iv$iv22);
                }
                $this$filterIsInstance$iv4 = (List)destination$iv$iv4;
                boolean $i$f$filter4 = false;
                $this$filterIsInstanceTo$iv$iv6 = $this$filter$iv6;
                destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterTo4 = false;
                Iterator iterator2 = $this$filterTo$iv$iv6.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv22 = iterator2.next();
                    Node item = (Node)element$iv$iv22;
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual((Object)item.name(), (Object)"action")) continue;
                    destination$iv$iv4.add(element$iv$iv22);
                }
                List actionItems = (List)destination$iv$iv4;
                Iterable $this$forEach$iv4 = actionItems;
                boolean $i$f$forEach4 = false;
                $this$filterTo$iv$iv6 = $this$forEach$iv4.iterator();
                while ($this$filterTo$iv$iv6.hasNext()) {
                    element$iv5 = $this$filterTo$iv$iv6.next();
                    Node action = (Node)element$iv5;
                    boolean bl8 = false;
                    if (!Intrinsics.areEqual((Object)action.attribute((Object)MANIFEST_NAME_KEY), (Object)"android.intent.action.VIEW")) continue;
                    intentFilterCheck.setHasActionView(true);
                }
                List list5 = appLinkIntent.children();
                Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"appLinkIntent.children()");
                Iterable $this$filterIsInstance$iv5 = list5;
                boolean $i$f$filterIsInstance5 = false;
                element$iv5 = $this$filterIsInstance$iv5;
                Collection destination$iv$iv5 = new ArrayList();
                boolean $i$f$filterIsInstanceTo5 = false;
                for (Object element$iv$iv3 : $this$filterIsInstanceTo$iv$iv5) {
                    if (!(element$iv$iv3 instanceof Node)) continue;
                    destination$iv$iv5.add(element$iv$iv3);
                }
                $this$filterIsInstance$iv5 = (List)destination$iv$iv5;
                boolean $i$f$filter5 = false;
                $this$filterIsInstanceTo$iv$iv5 = $this$filter$iv5;
                destination$iv$iv5 = new ArrayList();
                boolean $i$f$filterTo5 = false;
                element$iv$iv22 = $this$filterTo$iv$iv5.iterator();
                while (element$iv$iv22.hasNext()) {
                    element$iv$iv3 = element$iv$iv22.next();
                    Node item = (Node)element$iv$iv3;
                    boolean bl9 = false;
                    if (!Intrinsics.areEqual((Object)item.name(), (Object)"category")) continue;
                    destination$iv$iv5.add(element$iv$iv3);
                }
                List categoryItems = (List)destination$iv$iv5;
                Iterable $this$forEach$iv5 = categoryItems;
                boolean $i$f$forEach5 = false;
                $this$filterTo$iv$iv5 = $this$forEach$iv5.iterator();
                while ($this$filterTo$iv$iv5.hasNext()) {
                    element$iv4 = $this$filterTo$iv$iv5.next();
                    Node category = (Node)element$iv4;
                    boolean bl10 = false;
                    if (Intrinsics.areEqual((Object)category.attribute((Object)MANIFEST_NAME_KEY), (Object)"android.intent.category.DEFAULT")) {
                        intentFilterCheck.setHasDefaultCategory(true);
                    }
                    if (!Intrinsics.areEqual((Object)category.attribute((Object)MANIFEST_NAME_KEY), (Object)"android.intent.category.BROWSABLE")) continue;
                    intentFilterCheck.setHasBrowsableCategory(true);
                }
                List list6 = appLinkIntent.children();
                Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"appLinkIntent.children()");
                Iterable $this$filterIsInstance$iv6 = list6;
                boolean $i$f$filterIsInstance6 = false;
                element$iv4 = $this$filterIsInstance$iv6;
                Collection destination$iv$iv6 = new ArrayList();
                boolean $i$f$filterIsInstanceTo6 = false;
                for (Object element$iv$iv4 : $this$filterIsInstanceTo$iv$iv4) {
                    if (!(element$iv$iv4 instanceof Node)) continue;
                    destination$iv$iv6.add(element$iv$iv4);
                }
                $this$filterIsInstance$iv6 = (List)destination$iv$iv6;
                boolean $i$f$filter6 = false;
                $this$filterIsInstanceTo$iv$iv4 = $this$filter$iv4;
                destination$iv$iv6 = new ArrayList();
                boolean $i$f$filterTo6 = false;
                element$iv$iv3 = $this$filterTo$iv$iv4.iterator();
                while (element$iv$iv3.hasNext()) {
                    Object element$iv$iv5 = element$iv$iv3.next();
                    Node item = (Node)element$iv$iv5;
                    boolean bl11 = false;
                    if (!Intrinsics.areEqual((Object)item.name(), (Object)"data")) continue;
                    destination$iv$iv6.add(element$iv$iv5);
                }
                List dataItems = (List)destination$iv$iv6;
                Iterable $this$forEach$iv6 = dataItems;
                boolean $i$f$forEach6 = false;
                for (Object element$iv6 : $this$forEach$iv6) {
                    Map $this$forEach$iv7;
                    Node data = (Node)element$iv6;
                    boolean bl12 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)data.attributes(), (String)"data.attributes()");
                    boolean $i$f$forEach7 = false;
                    Iterator iterator3 = $this$forEach$iv7.entrySet().iterator();
                    while (iterator3.hasNext()) {
                        Map.Entry element$iv7;
                        Map.Entry entry = element$iv7 = iterator3.next();
                        boolean bl13 = false;
                        Object k = entry.getKey();
                        if (Intrinsics.areEqual(k, (Object)"android:scheme")) {
                            schemes.add(String.valueOf(entry.getValue()));
                            continue;
                        }
                        if (Intrinsics.areEqual(k, (Object)"android:host")) {
                            hosts.add(String.valueOf(entry.getValue()));
                            continue;
                        }
                        if (Intrinsics.areEqual(k, (Object)"android:pathAdvancedPattern")) {
                            paths.add(String.valueOf(entry.getValue()));
                            continue;
                        }
                        if (Intrinsics.areEqual(k, (Object)"android:pathPattern")) {
                            paths.add(String.valueOf(entry.getValue()));
                            continue;
                        }
                        if (Intrinsics.areEqual(k, (Object)"android:path")) {
                            paths.add(String.valueOf(entry.getValue()));
                            continue;
                        }
                        if (Intrinsics.areEqual(k, (Object)"android:pathPrefix")) {
                            paths.add(entry.getValue() + ".*");
                            continue;
                        }
                        if (!Intrinsics.areEqual(k, (Object)"android:pathSuffix")) continue;
                        paths.add(".*" + entry.getValue());
                    }
                }
                if (!(!((Collection)hosts).isEmpty()) && !(!((Collection)paths).isEmpty())) continue;
                if (schemes.isEmpty()) {
                    schemes.add(null);
                }
                if (hosts.isEmpty()) {
                    hosts.add(null);
                }
                if (paths.isEmpty()) {
                    paths.add(".*");
                }
                $this$forEach$iv6 = schemes;
                $i$f$forEach6 = false;
                for (Object element$iv6 : $this$forEach$iv6) {
                    String scheme = (String)element$iv6;
                    boolean bl14 = false;
                    Iterable $this$forEach$iv8 = hosts;
                    boolean $i$f$forEach8 = false;
                    for (Map.Entry element$iv7 : $this$forEach$iv8) {
                        String host = (String)((Object)element$iv7);
                        boolean bl15 = false;
                        Iterable $this$forEach$iv9 = paths;
                        boolean $i$f$forEach9 = false;
                        for (Object element$iv8 : $this$forEach$iv9) {
                            String path = (String)element$iv8;
                            boolean bl16 = false;
                            appLinkSettings.getDeeplinks().add(new Deeplink(scheme, host, path, intentFilterCheck));
                        }
                    }
                }
            }
        }
        return appLinkSettings;
    }

    public static final /* synthetic */ void access$logPluginCompileSdkWarnings(FlutterPluginUtils $this, int maxPluginCompileSdkVersion, int projectCompileSdkVersion, Logger logger, List pluginsWithHigherSdkVersion, File projectDirectory) {
        $this.logPluginCompileSdkWarnings(maxPluginCompileSdkVersion, projectCompileSdkVersion, logger, pluginsWithHigherSdkVersion, projectDirectory);
    }

    public static final /* synthetic */ void access$logPluginNdkWarnings(FlutterPluginUtils $this, String maxPluginNdkVersion, String projectNdkVersion, Logger logger, List pluginsWithDifferentNdkVersion, File projectDirectory) {
        $this.logPluginNdkWarnings(maxPluginNdkVersion, projectNdkVersion, logger, pluginsWithDifferentNdkVersion, projectDirectory);
    }

    public static final /* synthetic */ ProcessAndroidResources access$findProcessResources(FlutterPluginUtils $this, BaseVariantOutput baseVariantOutput) {
        return $this.findProcessResources(baseVariantOutput);
    }

    public static final /* synthetic */ AppLinkSettings access$createAppLinkSettings(FlutterPluginUtils $this, ApplicationVariant variant, BaseVariantOutput baseVariantOutput) {
        return $this.createAppLinkSettings(variant, baseVariantOutput);
    }
}

