/*
 * Decompiled with CFR 0.152.
 */
package com.flutter.gradle;

import com.android.build.api.AndroidPluginVersion;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.flutter.gradle.Version;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.text.StringsKt;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinAndroidPluginWrapper;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\nJ\r\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lcom/flutter/gradle/VersionFetcher;", "", "()V", "getAGPVersion", "Lcom/android/build/api/AndroidPluginVersion;", "project", "Lorg/gradle/api/Project;", "getAGPVersion$gradle", "getGradleVersion", "Lcom/flutter/gradle/Version;", "getGradleVersion$gradle", "getJavaVersion", "Lorg/gradle/api/JavaVersion;", "getJavaVersion$gradle", "getKGPVersion", "getKGPVersion$gradle", "gradle"})
@SourceDebugExtension(value={"SMAP\nVersionFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionFetcher.kt\ncom/flutter/gradle/VersionFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n288#2,2:123\n*S KotlinDebug\n*F\n+ 1 VersionFetcher.kt\ncom/flutter/gradle/VersionFetcher\n*L\n68#1:123,2\n*E\n"})
public final class VersionFetcher {
    @NotNull
    public static final VersionFetcher INSTANCE = new VersionFetcher();

    private VersionFetcher() {
    }

    @NotNull
    public final JavaVersion getJavaVersion$gradle() {
        JavaVersion javaVersion = JavaVersion.current();
        Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"current()");
        return javaVersion;
    }

    @NotNull
    public final Version getGradleVersion$gradle(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = project.getGradle().getGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.gradle.gradleVersion");
        String untrimmedGradleVersion = string;
        return Version.Companion.fromString(StringsKt.substringBefore$default((String)untrimmedGradleVersion, (char)'-', null, (int)2, null));
    }

    @Nullable
    public final AndroidPluginVersion getAGPVersion$gradle(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AndroidComponentsExtension androidComponentsExtension = (AndroidComponentsExtension)project.getExtensions().findByType(AndroidComponentsExtension.class);
        AndroidPluginVersion androidPluginVersion = androidComponentsExtension != null ? androidComponentsExtension.getPluginVersion() : null;
        return androidPluginVersion;
    }

    @Nullable
    public final Version getKGPVersion$gradle(@NotNull Project project) {
        Object object;
        KCallable versionField;
        KCallable kCallable;
        KotlinAndroidPluginWrapper kotlinPlugin;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String kotlinVersionProperty = "kotlin_version";
        String firstKotlinVersionFieldName = "pluginVersion";
        String secondKotlinVersionFieldName = "kotlinPluginVersion";
        if (project.hasProperty(kotlinVersionProperty)) {
            Object v = project.getProperties().get(kotlinVersionProperty);
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            return Version.Companion.fromString((String)v);
        }
        KotlinAndroidPluginWrapper kotlinAndroidPluginWrapper = kotlinPlugin = (KotlinAndroidPluginWrapper)project.getPlugins().findPlugin(KotlinAndroidPluginWrapper.class);
        String versionString = kotlinAndroidPluginWrapper != null ? kotlinAndroidPluginWrapper.getPluginVersion() : null;
        CharSequence charSequence = versionString;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return Version.Companion.fromString(versionString);
        }
        Object object2 = kotlinPlugin;
        if (object2 != null && (object2 = object2.getClass()) != null && (object2 = JvmClassMappingKt.getKotlinClass((Class)object2)) != null && (object2 = object2.getMembers()) != null) {
            Object v3;
            block7: {
                Iterable $this$firstOrNull$iv = (Iterable)object2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KCallable it = (KCallable)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)firstKotlinVersionFieldName) || Intrinsics.areEqual((Object)it.getName(), (Object)secondKotlinVersionFieldName))) continue;
                    v3 = element$iv;
                    break block7;
                }
                v3 = null;
            }
            kCallable = v3;
        } else {
            kCallable = null;
        }
        KCallable kCallable2 = versionField = kCallable;
        if (kCallable2 != null) {
            Object[] objectArray = new Object[]{kotlinPlugin};
            object = kCallable2.call(objectArray);
        } else {
            object = null;
        }
        versionString = (String)object;
        return versionString == null ? null : Version.Companion.fromString(versionString);
    }
}

